import java.util.Random;
/**
 * class Dobbelsteen - Beschrijft de werking van een dobbelsteen
 *
 * @author Dominiek Vandewalle
 * @version 2017-11-13
 */
public class Dobbelsteen
{
    private int aantalZijden;
    private int vorigeWorp;
    private Random getalGenerator;//zorgt voor het genereren van random getallen
    
    /**
     * Constructor voor objecten van de klasse Dobbelsteen.
     * @param   aantalZijden    Het aantal zijden van de dobbelsteen.
     */
    public Dobbelsteen(int aantalZijden)
    {
        this.aantalZijden = aantalZijden;
        getalGenerator = new Random();
        vorigeWorp = -1;
    }
    
    /**
     * Werpt de dobbelsteen. Er wordt nooit 2x na elkaar hetzelfde aantal ogen gegooid.
     */
    public void werp()
    {
        int nieuweWorp = getalGenerator.nextInt(aantalZijden) + 1;
        
        while(nieuweWorp != vorigeWorp)
        {
            nieuweWorp = getalGenerator.nextInt(aantalZijden) + 1;
        }
    }
    
    /**
     * Toont het aantal ogen van de dobbelsteen in het terminalvenster
     */
    public void print()
    {
        System.out.println(vorigeWorp);
    }
}
